import 'package:dartz/dartz.dart';
import 'package:flutter/cupertino.dart';

import '../../../core/theme/animation_duration.dart';
import '../../../core/utils/color_palette.dart';

class PresetAvatarItem extends StatelessWidget {
  final int index;
  final Function(Tuple2<int, String>) onPressed;
  final int? selectedIndex;

  const PresetAvatarItem({
    super.key,
    required this.index,
    required this.onPressed,
    required this.selectedIndex,
  });

  @override
  Widget build(BuildContext context) => CupertinoButton(
        padding: const EdgeInsets.all(8),
        onPressed: () =>
            onPressed(Tuple2(index, 'assets/avatars/a$index.png')), minimumSize: const Size(0, 0),
        child: AnimatedContainer(
          duration: AnimationDuration.pageStateTransitionMobile,
          width: 65,
          height: 65,
          decoration: BoxDecoration(
            border: Border.all(
              color: selectedIndex == index
                  ? ColorPalette.primary60
                  : ColorPalette.neutral99,
              width: 6.5,
            ),
            shape: BoxShape.circle,
            image: DecorationImage(
              image: AssetImage('assets/avatars/a$index.png'),
              fit: BoxFit.contain,
            ),
          ),
        ));
}
